//
//  CRMaterialTexture.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/2/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRMaterial.h"
#import "CRTexture.h"

extern NSString* const CRMaterialTextureKey;
extern NSString* const CRMaterialtextureDefaultTexturePathKey;

extern NSString* const CRMaterialTextureAdjustColorsKey;
extern NSString* const CRMaterialTextureHueAngleKey;
extern NSString* const CRMaterialTextureColorizeKey;
extern NSString* const CRMaterialTextureSaturationKey;
extern NSString* const CRMaterialTextureLightnessKey;

//////////////////////////////////////////////////////////////////////
// Texture material
//////////////////////////////////////////////////////////////////////
@interface CRMaterialTexture : CRMaterial
{
	NSString*	defaultTexturePath;
	CRTexture*	texture;
}

@property (nonatomic, strong)	CRTexture*	texture;
@property (nonatomic, copy)		NSString*	defaultTexturePath;

@property (nonatomic, assign)	BOOL		adjustColors;
@property (nonatomic, assign)	CGFloat		hueAngle;
@property (nonatomic, assign)	BOOL		colorize;
@property (nonatomic, assign)	CGFloat		saturation;
@property (nonatomic, assign)	CGFloat		lightness;

- (id)initWithDefaultTexturePath:(NSString *)aPath;
+ (id)materialWithDefaultTexturePath:(NSString *)aPath;

@end